#include "State.h"
#include "Context.h"

const int N=8;
const int SQRTNP1=3;

// Classes for the N puzzle (N+1 spots, sqrt(N+1) must be an integer

// Puzzle state is represented as vector of tile numbers in the pattern
//
//    0           1       2        3   Sqrt(N+1)-1
//    Sqrt(N+1) ...
//
//
// Each position contains a tile in the range 1..N, or 0, which is the blank space
// Additionally, the position of the space is stored separately
//


class NPuzzleState : public State {
private:
	unsigned contents[N+1];
	unsigned spacepos;
public:
	void     SetPos(unsigned pos, unsigned tile) { contents[pos]=tile; if (tile==0) {spacepos=pos;}};
	unsigned GetPos(unsigned pos) { return contents[pos]; };
	CompareResult Compare(State *s);
	void GenerateChildren();
	void DrawSelf(CDC *dc, CRect *rect);
	NPuzzleState & operator = (NPuzzleState &rhs);
};

class NPuzzleContext : public Context {
private:
	NPuzzleState *start,*goal;
public:
	NPuzzleContext();
	~NPuzzleContext();
	State *GetStartState() { return start;};
	int    IsGoalState(State *s) { return !(goal->Compare((NPuzzleState*)s));};
	void DrawContext(CDC *cdc);
	void GetContextRect(CRect *rect);
	double Heuristic(State *s);
};



