
#include "8puz.h"


NPuzzleState & NPuzzleState::operator = (NPuzzleState &rhs)
{
	unsigned i;

	spacepos=rhs.spacepos;

	for (i=0;i<N+1;i++) {
		contents[i]=rhs.contents[i];
	}

	return *this;
}

void NPuzzleState::GenerateChildren()
{
	NPuzzleState *temp;

	// Up
	if (spacepos>=SQRTNP1) {
		temp=new NPuzzleState;
		*temp=*this;
		temp->spacepos=spacepos-SQRTNP1;
		temp->contents[spacepos]=temp->contents[temp->spacepos];
		temp->contents[temp->spacepos]=0;
		temp->SetPath(GetPath()+1.0);
		AddChild(temp);
	}

	//Down
	if ((spacepos+SQRTNP1)<=(N)) {
		temp=new NPuzzleState;
		*temp=*this;
		temp->spacepos=spacepos+SQRTNP1;
		temp->contents[spacepos]=temp->contents[temp->spacepos];
		temp->contents[temp->spacepos]=0;
		temp->SetPath(GetPath()+1.0);
		AddChild(temp);
	}

	//Left
	if (spacepos%SQRTNP1 > 0) {
		temp=new NPuzzleState;
		*temp=*this;
		temp->spacepos=spacepos-1;
		temp->contents[spacepos]=temp->contents[temp->spacepos];
		temp->contents[temp->spacepos]=0;
		temp->SetPath(GetPath()+1.0);
		AddChild(temp);
	}

	//Right
	if (spacepos%SQRTNP1 < SQRTNP1-1) {
		temp=new NPuzzleState;
		*temp=*this;
		temp->spacepos=spacepos+1;
		temp->contents[spacepos]=temp->contents[temp->spacepos];
		temp->contents[temp->spacepos]=0;
		temp->SetPath(GetPath()+1.0);
		AddChild(temp);
	}
}

CompareResult NPuzzleState::Compare(State *s)
{
	NPuzzleState *foo=(NPuzzleState *)s;

	if (foo->spacepos!=spacepos) {
		return Larger;
	} else {
		unsigned i;

		for (i=0;i<N+1;i++) {
			if (contents[i]!=foo->contents[i]) {
				return Larger;
			}
		}
		return Equal;
	}
}

void NPuzzleState::DrawSelf(CDC *dc, CRect *rect)
{
	CBrush brush(RGB(0,0,0));
	unsigned dx=rect->Width()/SQRTNP1;
	unsigned dy=rect->Height()/SQRTNP1;
	unsigned x,y,i;
	char buf[80];
	CRect pixrect=*rect;

	dc->LPtoDP(&pixrect);

#if 0
	if (pixrect.Width()>=30 && pixrect.Height()>=30) {
		i=0;
		for (y=(unsigned)rect->top;i<N+1;y+=dy) {
			for (x=(unsigned)rect->left;;x+=dx,i++) {
				if (i==spacepos) {
					sprintf(buf,"X   ");
				} else {
					sprintf(buf,"%u   ",contents[i]);
				}
				dc->TextOut(x,y,buf,strlen(buf));
				if (i%SQRTNP1 == SQRTNP1-1) {
					++i;
					break;
				}
			}
		}
		dc->FrameRect(rect,&brush);
	} else {
		dc->Rectangle(rect);
	}
#else
		i=0;
		for (y=(unsigned)rect->top;i<N+1;y+=dy) {
			for (x=(unsigned)rect->left;;x+=dx,i++) {
				if (i==spacepos) {
					dc->FillSolidRect(x,y,dx,dy,RGB(0,0,0));
				} else {
					const unsigned MPY=256/(N+1);
					dc->FillSolidRect(x,y,dx,dy,RGB((N-contents[i])*MPY, contents[i]*MPY, contents[i]*MPY));
				}
				if (i%SQRTNP1 == SQRTNP1-1) {
					++i;
					break;
				}
			}
		}

#endif
	
}

NPuzzleContext::NPuzzleContext()
{
	unsigned i;
	start=new NPuzzleState;
	goal=new NPuzzleState;
	unsigned x,y;
	unsigned oldpos;
	unsigned tile;

	for (i=0;i<N+1;i++) {
		start->SetPos(i,i);
	}
	*goal=*start;

	x=y=0;

	for (i=0;i<100;i++) {
		oldpos=y*SQRTNP1+x;
		switch (rand()%4) {
		case 0:  // up
			y=(y>0) ? y-1 : y;
			break;
		case 1: // down
			y=(y<(SQRTNP1-1)) ? y+1 : y;
			break;
		case 2: //left
			x=(x>0) ? x-1  : x;
			break;
		case 3: //right
			x=(x<(SQRTNP1-1)) ? x+1 : x;
			break;
		}
		tile=goal->GetPos(y*SQRTNP1+x);
		goal->SetPos(oldpos,tile);
		goal->SetPos(y*SQRTNP1+x,0);
	}

}

NPuzzleContext::~NPuzzleContext()
{
	delete start;
	delete goal;
}


void NPuzzleContext::DrawContext(CDC *cdc)
{
	CRect rect(100,0,150,50);
	CPoint mv(0,55);

	cdc->TextOut(0,25,"Start",strlen("Start"));
	cdc->TextOut(0,75,"Goal",strlen("Goal"));
	
	start->DrawSelf(cdc,&rect);
	rect+=mv;
	goal->DrawSelf(cdc,&rect);
}

void NPuzzleContext::GetContextRect(CRect *rect)
{
	rect->left=rect->top=0;
	rect->bottom=55*2;
	rect->right=100+55;
}

inline unsigned ABS_DIFF(unsigned x, unsigned y)
{
	if (x>y) {
		return x-y;
	} else {
		return y-x;
	}
}

// This first pass just counts the number of tiles that
// Are out of place
// sum of manhattan distances
double NPuzzleContext::Heuristic(State *s)
{
	unsigned i,j,xoff,yoff;
	double dist=0.0, curdist;
	NPuzzleState *state=(NPuzzleState *)s;

	for (i=0;i<(N+1);i++) {
		for (j=0;j<(N+1);j++) {
			if ((state->GetPos(i)) == (goal->GetPos(j))) {
				break;
			}
		}
		xoff=ABS_DIFF(i%SQRTNP1,j%SQRTNP1);
		yoff=ABS_DIFF(i/SQRTNP1,j/SQRTNP1);
		curdist=xoff+yoff;
		dist+=curdist;
	}

	return dist;
}
