#include "Alg.h"
#include "UTILS.H"

SearchAlgorithm::SearchAlgorithm()
{
	context=NULL;
	computedboundsrect=0;
}

void SearchAlgorithm::Initialize(Context *c)
{
	context=c;
	startstate=c->GetStartState();
}

State *SearchAlgorithm::Step()
{
	computedboundsrect=0;
	return startstate;
}

SearchStatus SearchAlgorithm::GetStatus()
{
	if (context==NULL) {
		return NotInited;
	} else {
		return NotGoal;
	}
}

const int RECTSIZE=64;
const int INSETSIZE=8;

const CPoint INSTEP(RECTSIZE,0);
const CPoint DOWNSTEP(0,RECTSIZE);
const CRect  INSET(INSETSIZE,INSETSIZE,INSETSIZE,INSETSIZE);

void SearchAlgorithm::ComputeBounds()
{
	if (!computedboundsrect) {
		boundsrect.top=boundsrect.bottom=boundsrect.left=boundsrect.right=0;
		DrawSelf(NULL);
		computedboundsrect=1;
	}
}

unsigned SearchAlgorithm::DrawRecursive(CDC *cdc, State *s, CRect *where)
{
	State *child;
	unsigned count, numbelow;
	OPAQUE_POSITION pos;

	if (cdc==NULL) {                 // Computing Bounds
		boundsrect.right=MAX(boundsrect.right,where->right);
		boundsrect.bottom=MAX(boundsrect.bottom,where->bottom);
	} else {                         // Actually Drawing
		where->DeflateRect(&INSET);
		s->DrawSelf(cdc,where);
		where->InflateRect(&INSET);
		if (context->IsGoalState(s)) {
//			int oldrop=cdc->SetROP2(R2_XORPEN);
//			CBrush temp(RGB(0,128,0));
//			cdc->FillRect(where,&temp);
			cdc->MoveTo(boundsrect.left,boundsrect.top);
			cdc->LineTo(where->left,where->top);
			cdc->MoveTo(boundsrect.right,boundsrect.top);
			cdc->LineTo(where->right,where->top);
			cdc->MoveTo(boundsrect.left,boundsrect.bottom);
			cdc->LineTo(where->left,where->bottom);
			cdc->MoveTo(boundsrect.right,boundsrect.bottom);
			cdc->LineTo(where->right,where->bottom);
			cdc->InvertRect(where);
//			cdc->SetROP2(oldrop);
		} else if (s==startstate) {
//			int oldrop=cdc->SetROP2(R2_XORPEN);
//			CBrush temp(RGB(128,0,0));
//			cdc->FillRect(where,&temp);
			cdc->InvertRect(where);
//			cdc->SetROP2(oldrop);
		}
	}		



	pos=s->NewTraversal();
	child=s->FirstChild();
	*where+=INSTEP;
	if (child!=NULL) {
		if (cdc!=NULL) {
			cdc->MoveTo(where->left-INSETSIZE/2,where->top+RECTSIZE/2);
			cdc->LineTo(where->left,where->top+RECTSIZE/2);
		}
	} 

	count=1;
	numbelow=0;

	// Will not get executed if no children
	for (;child!=NULL;child=s->NextChild()) {
		*where+=DOWNSTEP;
		if (cdc!=NULL) {
			cdc->MoveTo(where->left,where->top-RECTSIZE*(count-1)-RECTSIZE/2);
			cdc->LineTo(where->left,where->top+RECTSIZE/2);
			cdc->LineTo(where->left+INSETSIZE/2,where->top+RECTSIZE/2);
		}
		count=DrawRecursive(cdc,child,where);
		numbelow+=count;
	}
	*where-=INSTEP;
	s->ResetTraversal(pos);
	return numbelow+1;
}

void SearchAlgorithm::DrawSelf(CDC *cdc)
{
	const CPoint origin(0,0);
	CRect rect(origin,INSTEP+DOWNSTEP);

	DrawRecursive(cdc,startstate,&rect);
}


void SearchAlgorithm::DrawStatus(CDC *cdc)
{
	CString temp="No Status For This Algorithm";

	cdc->TextOut(0,0,temp);
}

void SearchAlgorithm::GetStatusRect(CRect *rect)
{
	rect->left=0;
	rect->top=0;
	rect->bottom=500;
	rect->right=500;
}



