
// Algorithm base class

#ifndef __Alg
#define __Alg
#include "StdAfx.h"
#include "Context.h"

typedef enum {NotInited,GoalDone, NoGoalDone, GoalContinue, NotGoal} SearchStatus;

class SearchAlgorithm {
private:
	unsigned    DrawRecursive(CDC *cdc, State *s, CRect *rect);
protected:
	Context *context;
	State   *startstate;
	CRect    boundsrect;
	int		 computedboundsrect;
public:
	SearchAlgorithm();
	void           DrawSelf(CDC *cdc);
	void           ComputeBounds();
	void           GetBoundsRect(CRect *rect) { *rect=boundsrect; } ;
	virtual void   Initialize(Context *c);              // Must Set startstate;
	virtual State  *Step();                             // Returns the state that was expanded
	virtual SearchStatus GetStatus();	                // Returns status
	virtual void   GetStatusRect(CRect *rect);          // Size of the status window rectangle
	virtual void   DrawStatus(CDC *cdc);                // Optional - draw status info
};

#endif

