#include "BFS.h"

#include "UTILS.H"


BFS::BFS() : SearchAlgorithm(), Edge(), Dead()
{
	status=NotInited;
	numedge=numdead=0;
}

BFS::~BFS()
{
	Edge.Clear();
	Dead.Clear();
}

void BFS::Initialize(Context *c)
{
	SearchAlgorithm::Initialize(c);

	Edge.Clear();
	Dead.Clear();
	Edge.AddAtFront(startstate);
	status=NotGoal;
	numedge=1;
}

State *BFS::Step()
{
	State *state;

	SearchAlgorithm::Step();

	if ((state=Edge.RemoveFromFront())==NULL) {
		status=NoGoalDone;
		return NULL;
	}

	--numedge;

	if (context->IsGoalState(state)) {
		status=GoalDone;
		return state;
	}

	state->GenerateChildren();

	State *temp;

	for (temp=state->FirstChild();temp!=NULL;temp=state->NextChild()) {
		if (!Dead.IsInQueue(temp) && !Edge.IsInQueue(temp)) {
			Edge.AddAtBack(temp);
			++numedge;
		}
	}

	Dead.AddAtBack(state);
	++numdead;

	return state;

}


void BFS::DrawStatus(CDC *cdc)
{

	int i;
	State *temp;
	CRect rect(0,0,50,50);
	char *temp1="Edge:";
	char *temp2="Dead:";


	cdc->TextOut(0,25,temp1,strlen(temp1));
	cdc->TextOut(0,75,temp2,strlen(temp2));

	for (i=1,temp=Edge.First();temp!=NULL;temp=Edge.Next(),i++) {
		rect.left=i*50; 
		rect.right=rect.left+50;
		rect.top=0;
		rect.bottom=50;
		temp->DrawSelf(cdc,&rect);
	}

	for (i=1,temp=Dead.First();temp!=NULL;temp=Dead.Next(),i++) {
		rect.left=i*50; 
		rect.right=rect.left+50;
		rect.top=50;
		rect.bottom=100;
		temp->DrawSelf(cdc,&rect);
	}
}


void BFS::GetStatusRect(CRect *rect)
{

	rect->left=rect->top=0;
	rect->bottom=110; 
	rect->right=110+50*MAX(numedge,numdead);
}

	
	
	