#include "DFS.h"

DFS::DFS() : SearchAlgorithm(), curpath()
{
	status=NotInited;
	curparent=curchild=NULL;
	firststate=0;
	numstack=0;
}

DFS::~DFS()
{
	curpath.Clear();
}

void DFS::Initialize(Context *c)
{
	SearchAlgorithm::Initialize(c);

	curpath.Clear();
	curparent=startstate;
	curchild=NULL;
	curpath.Push(startstate); ++numstack;
	status=NotGoal;
	firststate=1;
}

State *DFS::Step()
{
	SearchAlgorithm::Step();


	if (context->IsGoalState(curparent)) {
		status=GoalDone;
		return curparent;
	}

	if (curchild==NULL) {                          // Special case for first node
		curparent->GenerateChildren();
		curchild=curparent->FirstChild();
		return curparent;
	}

	while (curchild==NULL || curpath.IsInQueue(curchild)) {
		if (curchild==NULL) {
			curparent=curpath.Pop();
			--numstack;
			if (curparent==NULL) {
				status=NoGoalDone;
				return NULL;
			}
		}
		curchild=curparent->NextChild();
	}

	if (context->IsGoalState(curchild)) {
		status=GoalDone;
		return curchild;
	}

	curpath.Push(curparent);
	curparent=curchild;
	curparent->GenerateChildren();
	curchild=curparent->FirstChild();
	++numstack;

	return curparent;
}
	
void DFS::DrawStatus(CDC *cdc)
{
	State *temp;
	CRect rect(0,0,50,50);
	CPoint mv(55,0);

	for (temp=curpath.Last();temp!=NULL;temp=curpath.Previous()) {
		temp->DrawSelf(cdc,&rect);
		rect+=mv;
	}
}


void  DFS::GetStatusRect(CRect *rect)
{
	rect->left=rect->top=0;
	rect->bottom=50;
	rect->right=numstack*55;
}



