// GDSAMDIDoc.cpp : implementation of the CGDSAMDIDoc class
//

#include "Context.h"
#include "BFS.h"
#include "DFS.h"
#include "ASTAR.h"
#include "8puz.h"

#include "stdafx.h"
#include "GDSAMDI.h"

#include "GDSAMDIDoc.h"
#include "GDSAMDIView.h"

#include "SpecAnimDlg.h"
#include "SelAlgDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIDoc

IMPLEMENT_DYNCREATE(CGDSAMDIDoc, CDocument)

BEGIN_MESSAGE_MAP(CGDSAMDIDoc, CDocument)
	//{{AFX_MSG_MAP(CGDSAMDIDoc)
	ON_COMMAND(ID_SEARCH_INITIALIZE, OnSearchInitialize)
	ON_COMMAND(ID_SEARCH_STEP, OnSearchStep)
	ON_COMMAND(ID_SEARCH_ANIMATE, OnSearchAnimate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIDoc construction/destruction

CGDSAMDIDoc::CGDSAMDIDoc()
{
	alg=NULL;
	context=NULL;
	expstate=NULL;
	amanimating=0;
	timer=0;
}

CGDSAMDIDoc::~CGDSAMDIDoc()
{
	delete alg;
	delete context;
}

BOOL CGDSAMDIDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	CSelAlgDlg dlg;
	if (dlg.DoModal()==IDOK) {
		switch (dlg.theval) {
		case 0:
			alg=new BFS;
			break;
		case 1:
			alg=new DFS;
			break;
		case 2:
			alg=new ASTAR;
			break;
		default:
			return FALSE;
		}
		context=new NPuzzleContext;
		return TRUE;
	} 

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIDoc serialization

void CGDSAMDIDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIDoc diagnostics

#ifdef _DEBUG
void CGDSAMDIDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGDSAMDIDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIDoc commands

void CGDSAMDIDoc::OnSearchInitialize() 
{
	alg->Initialize(context);
	UpdateAllViews(NULL);
}

void CGDSAMDIDoc::OnSearchStep() 
{
	if ((alg->GetStatus() != GoalDone) && (alg->GetStatus() != NoGoalDone)) {
		expstate=alg->Step();
		if (alg->GetStatus()==GoalDone) {
			AfxMessageBox("Search Done.  Goal Found!");
		}
		if (alg->GetStatus()==NoGoalDone) {
			AfxMessageBox("Search Done.  Goal NOT Found!");
		}

	}
	UpdateAllViews(NULL);
}

void CGDSAMDIDoc::AnimStep()
{
	unsigned i;

	for (i=0;i<(steps);i++) {
		if ((alg->GetStatus()!=GoalDone) && (alg->GetStatus()!=NoGoalDone)) {
			expstate=alg->Step();
		} else {
			timerview->KillTimer((UINT)this);
			amanimating=0;
			if (alg->GetStatus()==GoalDone) {
				AfxMessageBox("Search Done.  Goal Found!");
			}
			if (alg->GetStatus()==NoGoalDone) {
				AfxMessageBox("Search Done.  Goal NOT Found!");
			}
			break;
		}
	}

	UpdateAllViews(NULL);


}


void CALLBACK EXPORT TimerProc(HWND hwnd, UINT msg, UINT id, DWORD time)
{
	CGDSAMDIDoc *thedoc=(CGDSAMDIDoc*)id; // Oh, this is hideous
	thedoc->AnimStep();
}


void CGDSAMDIDoc::OnSearchAnimate() 
{

	if (amanimating) {
		timerview->KillTimer((UINT)this);
		amanimating=0;
		return;
	}

	POSITION pos = GetFirstViewPosition();
	CGDSAMDIView *view = (CGDSAMDIView*)GetNextView(pos);

	// Can only animate if we have a view
	if (view==NULL) {
		return;
	}

	CSpecAnimDlg dlg;
	
	if (dlg.DoModal()!=IDOK) {
		return;
	}

	UINT time = dlg.m_time;
	steps=dlg.m_steps;

	// OK, so we will register the first view to receive timer
	// messages, then we will expect it to force all to be updated

	timerview=view;
	if ((timer=timerview->SetTimer((UINT)this,time,TimerProc))==0) {
		AfxMessageBox("Sorry, Can't Animate.  No Timers Are Available.");
		::Beep(1000,1000);
	} else {
		amanimating=1;
	}

}



