// GDSAMDIView.cpp : implementation of the CGDSAMDIView class
//

#include "stdafx.h"
#include "GDSAMDI.h"

#include "GDSAMDIDoc.h"
#include "GDSAMDIView.h"

#include "Alg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView

IMPLEMENT_DYNCREATE(CGDSAMDIView, CScrollView)

BEGIN_MESSAGE_MAP(CGDSAMDIView, CScrollView)
	//{{AFX_MSG_MAP(CGDSAMDIView)
	ON_COMMAND(ID_TYPE_STATUS, OnTypeStatus)
	ON_COMMAND(ID_TYPE_ZOOMTOFIT, OnTypeZoomtofit)
	ON_COMMAND(ID_TYPE_SCROLLING, OnTypeScrolling)
	ON_COMMAND(ID_TYPE_CONTEXT, OnTypeContext)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView construction/destruction

CGDSAMDIView::CGDSAMDIView()
{
	viewtype=Scrolling;
}

CGDSAMDIView::~CGDSAMDIView()
{
}

BOOL CGDSAMDIView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView drawing

void CGDSAMDIView::OnDraw(CDC* pDC)
{
	CGDSAMDIDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	::GdiSetBatchLimit(1);
	switch (viewtype) {
	case Scrolling:
	case ZoomToFit:
		if (pDoc!=NULL && pDoc->alg->GetStatus() != NotInited) {
			pDoc->alg->DrawSelf(pDC);
		}
		break;
	case Status:
		if (pDoc!=NULL && pDoc->alg->GetStatus() != NotInited) {
			pDoc->alg->DrawStatus(pDC);
		}
		break;
	case Context:
		if (pDoc!=NULL) {
			pDoc->context->DrawContext(pDC);
		}
		break;
	}
	::GdiSetBatchLimit(0);

}

void CGDSAMDIView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();
	CSize sizeTotal;
	// TODO: calculate the total size of this view
//	sizeTotal.cx = sizeTotal.cy = 100;
//	SetScrollSizes(MM_TEXT, sizeTotal);
}

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView printing

BOOL CGDSAMDIView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CGDSAMDIView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CGDSAMDIView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView diagnostics

#ifdef _DEBUG
void CGDSAMDIView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CGDSAMDIView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CGDSAMDIDoc* CGDSAMDIView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGDSAMDIDoc)));
	return (CGDSAMDIDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGDSAMDIView message handlers

void CGDSAMDIView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CGDSAMDIDoc *pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	CRect brect;
	CSize sizeTotal;

	switch (viewtype) {
	case Status:
		if (pDoc->alg->GetStatus() == NotInited) {
			sizeTotal.cx=100;
			sizeTotal.cy=100;
		} else {
			pDoc->alg->GetStatusRect(&brect);
			sizeTotal.cx=brect.right-brect.left;
			sizeTotal.cy=brect.bottom-brect.top;
		}
		break;
	case Context:
		pDoc->context->GetContextRect(&brect);
		sizeTotal.cx=brect.right-brect.left;
		sizeTotal.cy=brect.bottom-brect.top;
		break;
	case Scrolling:
	case ZoomToFit:
		if (pDoc->alg->GetStatus() == NotInited) {
			sizeTotal.cx=100;
			sizeTotal.cy=100;
		} else {
			pDoc->alg->ComputeBounds();
			pDoc->alg->GetBoundsRect(&brect);
	
			sizeTotal.cx=brect.right-brect.left;
			sizeTotal.cy=brect.bottom-brect.top;
		}
	}

	switch (viewtype) {
	case Scrolling:
	case Status:
		SetScrollSizes(MM_TEXT, sizeTotal);
		break;
	case ZoomToFit:
	case Context:
		GetParentFrame()->RecalcLayout();
		SetScaleToFitSize(sizeTotal);
	}

	Invalidate();
}

void CGDSAMDIView::OnTypeScrolling() 
{
	viewtype=Scrolling;
	OnUpdate(NULL,0,NULL);
}

void CGDSAMDIView::OnTypeStatus() 
{
	viewtype=Status;
	OnUpdate(NULL,0,NULL);
}

void CGDSAMDIView::OnTypeZoomtofit() 
{
	viewtype=ZoomToFit;
	OnUpdate(NULL,0,NULL);
}


void CGDSAMDIView::OnTypeContext() 
{
	viewtype=Context;
	OnUpdate(NULL,0,NULL);
	
}
