
#include "Simple.h"

void SimpleState::GenerateChildren()
{
	SimpleState *temp;

	switch (loc) {
	case ul:
		temp=new SimpleState;
		temp->loc=ur;
		temp->SetParent(this);
		AddChild(temp);
		temp=new SimpleState;
		temp->loc=ll;
		temp->SetParent(this);
		AddChild(temp);
		break;
	case ur:
		temp=new SimpleState;
		temp->loc=ul;
		temp->SetParent(this);
		AddChild(temp);
		temp=new SimpleState;
		temp->loc=lr;
		temp->SetParent(this);
		AddChild(temp);
		break;
	case ll:
		temp=new SimpleState;
		temp->loc=ul;
		temp->SetParent(this);
		AddChild(temp);
		temp=new SimpleState;
		temp->loc=lr;
		temp->SetParent(this);
		AddChild(temp);
		break;
	case lr:
		temp=new SimpleState;
		temp->loc=ur;
		temp->SetParent(this);
		AddChild(temp);
		temp=new SimpleState;
		temp->loc=ll;
		temp->SetParent(this);
		AddChild(temp);
		break;
	}
}

CompareResult SimpleState::Compare(State *s)
{
	SimpleState *foo=(SimpleState *)s;

	if (foo->loc==loc) {
		return Equal;
	} else {
		return Larger;
	}
}

void SimpleState::DrawSelf(CDC *dc, CRect *rect)
{
	CBrush brush(RGB(0,0,0));
	CRect temprect=*rect;

	dc->FrameRect(&temprect,&brush);
	
	switch (loc) {
	case ur:
	case lr:
		temprect.DeflateRect((rect->right-rect->left)/2,0,0,0);
		break;
	case ul:
	case ll:
		temprect.DeflateRect(0,0,(rect->right-rect->left)/2,0);
		break;
	default:
		;
	}

	switch(loc) {
	case lr:
	case ll:
		temprect.DeflateRect(0,(rect->bottom-rect->top)/2,0,0);
		break;
	case ur:
	case ul:
		temprect.DeflateRect(0,0,0,(rect->bottom-rect->top)/2);
		break;
	default:
		;
	}

	dc->FillRect(&temprect,&brush);
}

State *SimpleContext::GetStartState()
{
	SimpleState *temp=new SimpleState;
	temp->SetLoc(ul);
	return temp;
}

int SimpleContext::IsGoalState(State *s)
{
	SimpleState temp;

	temp.SetLoc(lr);

	if (temp.Compare(s)==Equal) {
		return 1;
	} else {
		return 0;
	}
}