#include "State.h"
#include "Context.h"

// Classes for a very simple puzzle.
// the puzzle has four spaces (2x2), start in
// top left, must walk to bottom right.

typedef enum {ul, ur, ll, lr} ValidLoc;

class SimpleState : public State {
private:
	ValidLoc loc;
public:
	void SetLoc(ValidLoc l) { loc=l;};
	ValidLoc GetLoc() { return loc;};
	CompareResult Compare(State *s);
	void GenerateChildren();
	void DrawSelf(CDC *dc, CRect *rect);
};

class SimpleContext : public Context {
public:
	State *GetStartState();
	int    IsGoalState(State *s);
};


