#include "State.h"

StateList::StateList()
{
	first=current=NULL;
}

StateList::~StateList()
{
	StateListNode *temp, *prev;

	for (temp=first;temp!=NULL;) {
		prev=temp;
		temp=temp->next;
		delete prev;
	}

	first=current=NULL;
}

void StateList::AddState(State *s)
{
	StateListNode *n = new StateListNode;

	n->state=s;
	n->next=first;
	first=n;
}

State * StateList::FindState(State *s)
{
	StateListNode *temp;

	for (temp=first;temp!=NULL;temp=temp->next) {
		if (temp->state->Compare(s) == Equal) {
			return temp->state;
		}
	}
	return NULL;
}

void StateList::DeleteState(State *s)
{
	StateListNode *temp, *prev;

	for (temp=prev=first;temp!=NULL;prev=temp,temp=temp->next) {
		if (temp->state->Compare(s) == Equal) {
#if 0
			if (current==temp) {
					(StateList::temp)=*current;
					current=&(StateList::temp);
			}
#else 
			if (current==temp) {
				current=current->next;
			}
#endif
			if (temp==first) {
				first=temp->next;
			} else {
				prev->next=temp->next;
			}
			delete temp;
			break;
		}
	}

}


State *StateList::FirstState()
{
#if 0
	current=first;

	if (current!=NULL) {
		return current->state;
	} else {
		return NULL;
	}
#else
	if (first==NULL) {
		current=NULL;
		return NULL;
	} else {
		current=first->next;
		return first->state;
	}
#endif
}

State *StateList::NextState()
{

#if 0
	if (current==NULL) {
		return NULL;
	}
	
	current=current->next;

	if (current!=NULL) {
		return current->state;
	} else {
		return NULL;
	}
#else
	if (current==NULL) {
		return NULL;
	} else {
		State *ret=current->state;
		current=current->next;
		return ret;
	}
#endif
	
	current=current->next;

	if (current!=NULL) {
		return current->state;
	} else {
		return NULL;
	}
}



State::State()
{
	parent=NULL;
	children=new StateList;
}

State::~State()
{
	parent=NULL;
	delete children;
}


int State::SetParent(State *p)
{
	parent=p;
	return 0;
}

int State::AddChild(State *p)
{
	children->AddState(p);
	p->SetParent(this);
	return 0;
}
	
int State::DeleteChild(State *c)
{
	if (children->FindState(c) != NULL ) {
		children->DeleteState(c);
		c->SetParent(NULL);
	}
	return 0;
}


State * State::GetParent()
{
	return parent;
}

State * State::FirstChild()
{
	return children->FirstState();
}

State * State::NextChild()
{
	return children->NextState();
}


CompareResult State::Compare(State *p)
{
	return Equal;
}

void State::GenerateChildren()
{
	children->AddState(this);
}

void State::DrawSelf(CDC *cdc, CRect *rect)
{
	cdc->Ellipse(rect);
}

